GO
CREATE TABLE [sSystem].[tTraceLog](
	[Id] [bigint] IDENTITY(1,1) NOT NULL,
	[LogMessage] [nvarchar](max) NULL,
	[ExtraLogMessage] [nvarchar](max) NULL,
	[ExeceptionLog] [nvarchar](max) NULL,
	[ExceptionDetailLog] [nvarchar](max) NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[PagePath] [nvarchar](1000) NULL,
PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO


-----------

GO

CREATE PROCEDURE [sSystem].[pTraceLogAdd] 
	 @rLogMessage NVARCHAR(MAX) = ''
	,@rExtraLogMessage NVARCHAR(MAX) = ''
	,@rExeceptionLog NVARCHAR(MAX) = ''
	,@rExceptionDetailLog NVARCHAR(MAX) = ''
	,@rPagePath NVARCHAR(1000) = ''

	WITH EXECUTE AS CALLER
AS
SET NOCOUNT ON

BEGIN
	INSERT INTO [sSystem].[tTraceLog] (
		LogMessage
		,ExtraLogMessage
		,ExeceptionLog
		,ExceptionDetailLog
		,CreatedDateTime
		,PagePath
		)
	VALUES (
		@rLogMessage
		,@rExtraLogMessage
		,@rExeceptionLog
		,@rExceptionDetailLog
		,sCommon.fGetDate()
		,@rPagePath
		)
END
